/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xfacthd.buddingcrystals.common.BCContent;

public final class OptionalLootItem
extends LootPoolSingletonContainer {
    private final Item item;

    private OptionalLootItem(Item item, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.item = item;
    }

    protected void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        stackConsumer.accept(new ItemStack((ItemLike)this.item));
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableItem(ItemLike item) {
        return OptionalLootItem.m_79687_((weight, quality, conditions, functions) -> new OptionalLootItem(item.m_5456_(), weight, quality, conditions, functions));
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)BCContent.OPTIONAL_LOOT_ITEM.get();
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<OptionalLootItem> {
        public void serializeCustom(JsonObject object, OptionalLootItem loot, JsonSerializationContext ctx) {
            super.m_7219_(object, (LootPoolSingletonContainer)loot, ctx);
            ResourceLocation name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)loot.item);
            if (name == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + loot.item);
            }
            object.addProperty("name", name.toString());
        }

        protected OptionalLootItem deserialize(JsonObject object, JsonDeserializationContext ctx, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            if (!object.has("name") || !object.get("name").isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected name to be an item, was " + GsonHelper.m_13883_((JsonElement)object));
            }
            Item item = Items.f_41852_;
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(object.get("name").getAsString()))) {
                item = GsonHelper.m_13909_((JsonObject)object, (String)"name");
            }
            return new OptionalLootItem(item, weight, quality, conditions, functions);
        }
    }
}

